#include "Model.h"

#include "Command.h"
#include "Canvas.h"
#include "Ellipse.h"
#include "Group.h"
#include "Image.h"
#include "Images.h"
#include "Text.h"

#include "Arrow.h"
#include "ScreenController.h"

#include <Core/Core.h>
using Upp::callback1;

namespace gm {

	

	//##ModelId=4D6CBC960177
	Model::Model(ModelType t) 
		: type(t)
		, editor(NULL)
		{
			commands.push_back(new Command(getImage("img_class") 
																		,"A class is a container for functions, variables and bugs."
																		,THISBACK1(cb_create, Class))
												);
			commands.push_back(new Command(getImage("usecase") 
																		,"A piece of the system someon can act with or against."
																		,THISBACK1(cb_create, Usecase))
												);
			commands.push_back(new Command(getImage("img_actor") 
																		,"A role/user or process that acts with the system."
																		,THISBACK1(cb_create, Actor))
												);
			commands.push_back(new Command(getImage("img_note") 
																		,"Some notes about something."
																		,THISBACK1(cb_create, Note))
												);
			commands.push_back(new Command(getImage("img_label") 
																		,"A label that can be attached to a connector."
																		,THISBACK1(cb_create, Label))
												);
			commands.push_back(new Command(getImage("img_isa")
																			,"Inheritance of one derived class from its base class."
																			,THISBACK1(cb_startWiring, BinISA))
													);
			commands.push_back(new Command(getImage("img_dep") 
																		,"A dependency between a dependant and its dependency."
																		,THISBACK1(cb_startWiring, BinDEP))
												);
			commands.push_back(new Command(getImage("img_has") 
																		,"A relation between an owner and its owned object."
																		,THISBACK1(cb_startWiring, BinHAS))
												);
			commands.push_back(new Command(getImage("img_has2") 
																		,"A relation between an owner and its aggregate object."
																		,THISBACK1(cb_startWiring, BinAGG))
												);
			commands.push_back(new Command(getImage("img_clean") 
																		,"Clear all."
																		,THISBACK1(cb_startWiring, BinAGG))
												);
		}

	//##ModelId=4D6CBC5A01D4
	ModelEditor* Model::edit() {
		switch(type){
			case ClassDiagram:
				{
					diagram=new cv::Diagram();
					diagram->player = this;
					editor=ScreenController::diagram(diagram);
#if 0
					{
						Model* m1;
						Model* m2;
						Model* cn;
						
						m1=create(Class,"Hello");
						m2=create(Class,"World");
						cn=new Model(BinISA);
						Canvas* c= new cv::Connector(diagram);
					}
#endif					
					//editor->Run();
					Ctrl::EventLoop();
					
					return NULL; // this is a strange case: the editor exists in the diagram ...
				}
				break;
		}
	}

	void Model::create(ModelType type, Model** newModel, Canvas** newCanvas){
	}

	//##ModelId=4D6D2F1D0196
	Model* Model::create(ModelType type, std::string _name) {
		Model* m=new Model(type);
		m->name = _name;
		if (type == Label)
		{
			diagram->selectConnectorRelativePoint(m);
			return m;
		}
		
		cv::Group* g;
		g=new cv::Group(diagram);
		g->player = m;
		diagram->add(g);
		switch(type){
			case Actor:
				{
					g->bordered=false;
					cv::Image* obj = g->addImage("actor");
					g->addText(_name);
				}
				break;
			case Usecase:
				{
					g->bordered=false;
					cv::Ellipse* obj = g->addEllipse();
					obj->set_extent(cv::Point(50,20));
					g->addText(_name);
				}
				break;
			case Class:
				{
					g->addText(_name);
					g->addSeparator();
					g->addSeparator();
				}
				break;
		}
		double yy = diagram->bounds().bottom + 100;
		if (yy>600) yy=600;
		g->set_origin(cv::Point(100,yy));
		return m;
	}

	//##ModelId=4D6EDF2F008C
	void Model::cb_startWiring(ModelType type) {
		cv::Connector* cn;
		cn=new cv::Connector(diagram);
		cn->player = new Model(type);
		switch(type){
			case BinISA:
				cn->head->arrow->type = cv::ClosedEmpty;
				cn->tail->arrow->type = cv::None;
				break;
			case BinDEP:
				cn->head->arrow->type = cv::OpenArrow;
				cn->tail->arrow->type = cv::None;
				cn->dashed = true;
				break;
			case BinHAS:
				cn->head->arrow->type = cv::OpenArrow;
				cn->tail->arrow->type = cv::DiamondEmpty;
				//cn->newLabel("HEAD",cv::NearHead);
				cn->newLabel("CENTER",cv::NearCenter);
				//cn->newLabel("TAIL",cv::NearTail);
				break;
		}
		diagram->startWiring(cn);
	}

	//##ModelId=4D6EF76400DA
	void Model::cb_create(ModelType type) {
		create(type,"unnamed");
		editor->Refresh();
	}

	//##ModelId=4D6F6F1A003E
	bool Model::canApplyTo(Handler* m) {
		Model* mm = dynamic_cast<Model*>(m);
		switch(this->type){
			case BinISA:
				return mm->type == Class;
			default: 
				return true;
		}
	}
	
	//##ModelId=4D6F6F1D0128
	bool Model::canConnectTo(Handler* m) {
		Model* mm = dynamic_cast<Model*>(m);
		switch(this->type){
			case BinISA: 
				return mm->type == Class;
			default: 
				return true;
		}
	}

	//##ModelId=4D701AC602BF
	void Model::setSelected(bool state) 
	{
		TopWindow* w = ScreenController::sharedEditor();
		w->Show(true);
		w->TopMost();
		//editor->obj_id_value.Set(name);
	}
}


